% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-labels-texts.R
\name{axis_labels_uk}
\alias{axis_labels_uk}
\alias{axis_labels_none}
\alias{axis_labels}
\title{Default text for axis labels}
\usage{
axis_labels_uk(append = "", sep = "")

axis_labels_none()

axis_labels(append = "", sep = "")
}
\arguments{
\item{append}{character The string to be appended to each label,}

\item{sep}{character Passed to function \code{paste} as argument for
parameter \code{sep}.}
}
\value{
A character vector
}
\description{
Texts used by default for axis labels in plots are recalled from character
vectors returned by these functions. The aim is that their default values can
be easily changed or translated to other languages. They contain only the
text part, but not symbols or units of expression.
}
\details{
By default \code{axis_labels()} contains a copy of
  \code{axis_labels_uk_comma()}. By assigning to this name a user function
  that returns a named character vector using the same names for its members
  as those returned by these functions, it is possible to temporarily change
  the default texts.

  Currently only UK English label texts are predefined and
  \code{axis_labels()} is a synonym of \code{axis_labels_uk()}.
}
\examples{
names(axis_labels())

axis_labels()[["w.length"]] # no comma
axis_labels(append = ",")[["w.length"]] # ending in a comma

axis_labels_uk()[["w.length"]] # English (same as default)
axis_labels_none()[["w.length"]] # empty label

}
