% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_sparklabels.R
\docType{data}
\name{SparkLabels}
\alias{SparkLabels}
\alias{stat_sparklabels}
\title{Sparkline labels or points}
\usage{
stat_sparklabels(
  mapping = NULL,
  data = NULL,
  geom = "label",
  label_fun = NULL,
  position = "identity",
  show.legend = TRUE,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{either "point", "text", "label", "text_repel", or "label_repel"}

\item{label_fun}{function to adapt labels (p. ex. round or add suffixes)}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\description{
stat for points or labels at the start, end, max, and min values of a line.
will automatically compute them from x and y aesthetics.
can use either geom = "point"
}
\details{
This should be used in combination with `geom_line()` in order to
  draw sparklines.
}
\section{Aesthetics}{

\itemize{
\item x
\item y
}
}

\examples{
library(ggplot2)

ggplot(airquality, aes(Day, Wind, group = Month)) + 
  stat_interquartilerange(geom = "ribbon",
                          show.legend = FALSE) +
  geom_line() + 
  scale_y_continuous(limits = c(0, 25)) + 
  facet_grid(Month~.) +
  ggtitle("Daily wind intensity by month in NYC") +
  theme_minimal()
}
\references{
Tufte, Edward R. (n.d.) Sparkline theory and practice
https://www.edwardtufte.com/bboard/q-and-a-fetch-msg?msg_id=0001OR&topic_id=1
}
\keyword{datasets}
