% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_pitch.R
\name{goals_box}
\alias{goals_box}
\alias{goals_strip}
\alias{goals_line}
\title{Goals markings}
\usage{
goals_box(
  colour,
  fill,
  dimensions,
  linewidth = 1,
  alpha = 1,
  linetype = "solid",
  offset = 2,
  ...
)

goals_strip(
  colour,
  fill,
  dimensions,
  linewidth = 1,
  alpha = 1,
  linetype = "solid",
  offset = 1,
  lineend = "round",
  ...
)

goals_line(
  colour,
  fill,
  dimensions,
  ...,
  linewidth = 1,
  linetype = NULL,
  relative_width = 3
)
}
\arguments{
\item{colour}{Colour of pitch outline.}

\item{fill}{Colour of pitch fill.}

\item{dimensions}{A list containing the pitch dimensions to draw. See \code{help(pitch_opta)}.}

\item{linewidth}{Determines line thickness in \code{goals_strip} and \code{goals_line}.}

\item{alpha}{Determines alpha in \code{goals_box}.}

\item{linetype}{Determines linetype in \code{goals_box} and \code{goals_strip}.}

\item{offset}{Determines how deep the goal extends.}

\item{...}{Passed onto underlying \code{ggplot2::annotate} calls.}

\item{lineend}{Determines lineend in \code{goals_strip} and \code{goals_line}.}

\item{relative_width}{Determines relative width of the goal marking to the pitch markings in \code{goals_line}.}
}
\value{
list of ggplot geoms to be added to a ggplot plot
}
\description{
Various functions can be supplied to \code{annotate_pitch} to specify the appearance
of goals in the resulting plot.
}
\details{
Each function takes \code{colour}, \code{fill}, and \code{dimensions} arguments. User-defined
functions with the same arguments can also be used
}
\examples{
library(ggplot2)

shots_data <- data.frame(x = c(90, 85, 82, 78, 83),
                         y = c(43, 40, 52, 56, 44))

# Default
ggplot(shots_data, aes(x = x, y = y)) +
  annotate_pitch(goals = goals_box) +
  geom_point()

# Other goals markings
ggplot(shots_data, aes(x = x, y = y)) +
  annotate_pitch(goals = goals_strip) +
  geom_point()

# Partial functions can be used to customise further
ggplot(shots_data, aes(x = x, y = y)) +
  annotate_pitch(goals = ~ goals_box(..., offset = 4)) +
  geom_point()

}
