#' Simulated Exposure Response Data
#'
#' A dataset containing data suitable for logistic regression
#'
#' @format A data frame with 600 rows and 10 variables
#' \describe{
#'   \item{STUDY}{Study identifier}
#'   \item{ID}{Subject Identifier}
#'   \item{DOSE}{Dose, in mg}
#'   \item{GBDS}{Dose, in alternative salt}
#'   \item{SEX}{Sex of the subject}
#'   \item{AGE}{age of the subject, in years}
#'   \item{WT}{weight of the subject, in kg}
#'   \item{RACE}{Race of the subject}
#'   \item{CRCL}{Creatinine clearance}
#'   \item{BRLS}{RLS score}
#'   \item{PRLS}{RLS score}
#'   \item{AUC}{Area under the curve exposure}
#'   \item{CMAX}{Maximun concentration exposure}
#'   \item{ICGI}{response 0/1}
#'   \item{ICGI7}{response 1 to 7}
#' }
#' @source inspired from a real data submission
#' @examples
#' logistic_data
"logistic_data"
