% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcp_select.r
\name{pcp_select}
\alias{pcp_select}
\title{Data wrangling for GPCPs: Step 1 variable selection}
\usage{
pcp_select(data, ...)
}
\arguments{
\item{data}{a dataframe or tibble}

\item{...}{choose the columns to be used in the parallel coordinate plot.
Variables can be selected by position, name or any of the \code{tidyselect} selector functions.}
}
\value{
dataframe of a long form of the selected variables with extra columns:\tabular{ll}{
   \strong{variable} \tab \strong{functionality} \cr
   \code{pcp_x}, \code{pcp_y} \tab values for the mappings to x and y axes \cr
   \code{pcp_yend} \tab vertical endpoint of a line segment \cr
   \code{pcp_class} \tab type of each of the input variables \cr
   \code{pcp_level} \tab preserves order of levels in categorical variables \cr
   \code{pcp_id} \tab identifier for each observation \cr
}


The dimensions of the returned data set are:  6 + the number of input variables for its
columns. The number of rows is given as the multiple of the number of selected
variables and the number of rows in the original data.
}
\description{
The \code{pcp_select} function allows a selection of variables from a data set.
These variables are transformed into an embellished long form of the data.
}
\details{
The data pipeline feeding any of the geom layers in the \code{ggpcp} package is implemented in a three-step modularized
form rather than as the stat functions more typical for \code{ggplot2} extensions.
The three steps of data pre-processing are:\tabular{ll}{
   \strong{command} \tab \strong{data processing step} \cr
   \code{pcp_select} \tab variable selection (and horizontal ordering) \cr
   \code{pcp_scale} \tab (vertical) scaling of values \cr
   \code{pcp_arrange} \tab dealing with tie-breaks on categorical axes \cr
}


Note that these data processing steps are executed before the call to \code{ggplot2}
and the identity function is used by default in all of the \code{ggpcp} specific layers.
Besides the speed-up by only executing the processing steps once for all layers,
the separation has the additional benefit, that it provides the users with the
possibility to make specific choices at each step in the process. Additionally,
separation allows for a cleaner user interface: parameters affecting the data
preparation process can be moved to the relevant (set of) function(s) only, thereby
reducing the  number of arguments without any loss of functionality.
}
\examples{
data(Carcinoma)
dim(Carcinoma)
# select all variables
pcp_data <- Carcinoma |> pcp_select(1:9)
dim(pcp_data) # 6 more columns, 9 times as many observations
head(pcp_data)
}
\seealso{
\code{\link[=pcp_scale]{pcp_scale()}}, \code{\link[=pcp_arrange]{pcp_arrange()}}
}
