% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda.R
\name{lambdalasso}
\alias{lambdalasso}
\alias{lambdalasso.default}
\alias{lambdalasso.fullrank}
\title{Estimation of Lambda Sequence for Linear Mixed Model with Lasso Penalty}
\usage{
lambdalasso(ggmix_object, ...)

\method{lambdalasso}{default}(ggmix_object, ...)

\method{lambdalasso}{fullrank}(
  ggmix_object,
  ...,
  penalty.factor,
  lambda_min_ratio,
  epsilon = 1e-14,
  tol.kkt = 1e-09,
  eta_init = 0.5,
  nlambda = 100,
  scale_x = FALSE,
  center_y = FALSE
)
}
\arguments{
\item{ggmix_object}{A ggmix_object object of class \code{lowrank} or
\code{fullrank}}

\item{...}{Extra parameters. Currently ignored.}

\item{penalty.factor}{Separate penalty factors can be applied to each
coefficient. This is a number that multiplies lambda to allow differential
shrinkage. Can be 0 for some variables, which implies no shrinkage, and
that variable is always included in the model. Default is 1 for all
variables}

\item{lambda_min_ratio}{Smallest value for lambda, as a fraction of
lambda.max, the (data derived) entry value (i.e. the smallest value for
which all coefficients are zero). The default depends on the sample size
nobs relative to the number of variables nvars. If nobs > nvars, the
default is 0.0001, close to zero. If nobs < nvars, the default is 0.01. A
very small value of lambda.min.ratio will lead to a saturated fit in the
nobs < nvars case.}

\item{epsilon}{Convergence threshold for block relaxation of the entire
parameter vector \eqn{\Theta = ( \beta, \eta, \sigma^2 )}. The algorithm
converges when \deqn{crossprod(\Theta_{j+1} - \Theta_{j}) < \epsilon}.
Defaults value is 1E-4}

\item{tol.kkt}{KKT tolerance. Currently ignored}

\item{eta_init}{initial value for the eta parameter, with \eqn{0 < \eta < 1}
used in determining lambda.max and starting value for fitting algorithm.}

\item{nlambda}{the number of lambda values - default is 100.}

\item{scale_x}{should the columns of x be scaled - default is FALSE}

\item{center_y}{should y be mean centered - default is FALSE.}
}
\value{
A decreasing sequence of tuning parameters
}
\description{
\code{lambdalasso} estimates a decreasing sequence of tuning
  parameters
}
\note{
This function isn't meant to be called directly by the user.
}
\seealso{
\code{\link{ggmix}}
}
