% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_mega.R
\name{read_mega}
\alias{read_mega}
\title{Process MEGA CSV Files}
\usage{
read_mega(folder_path)
}
\arguments{
\item{folder_path}{Path to directory containing MEGA CSV files. Files should follow
MEGA format with columns for Codon, Count, and RSCU values.}
}
\value{
A data frame containing:
\describe{
  \item{AA}{Amino acid abbreviation}
  \item{Codon}{DNA codon sequence}
  \item{Fill}{Position index within amino acid group}
  \item{Species}{Species identifier from file name}
  \item{RSCU}{Calculated Relative Synonymous Codon Usage value}
}
}
\description{
Reads and processes MEGA-generated CSV files from a specified directory,
extracts codon usage data, and returns a consolidated dataset.
}
\details{
Processes files through these steps:
\enumerate{
  \item Identifies valid header lines containing "Codon", "Count", and "RSCU"
  \item Extracts codon/amino acid data below headers
  \item Calculates position indices (Fill) for synonymous codons
  \item Combines all species data into a single data frame
}
}
\examples{
# Using example data
example_dir <- system.file("extdata", "mega", package = "ggmRSCU")
result <- read_mega(example_dir)
head(result)

}
