% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_y_hdx.R
\name{scale_y_continuous_hdx}
\alias{scale_y_continuous_hdx}
\alias{scale_y_log10_hdx}
\alias{scale_y_reverse_hdx}
\alias{scale_y_sqrt_hdx}
\title{Position scales for continuous y data}
\usage{
scale_y_continuous_hdx(...)

scale_y_log10_hdx(...)

scale_y_reverse_hdx(...)

scale_y_sqrt_hdx(...)
}
\arguments{
\item{...}{Other arguments pass on to \code{\link[ggplot2:scale_continuous]{ggplot2::scale_y_continuous()}}.}
}
\value{
\code{ggplot2::ScaleContinuousPosition} object to scale a
\code{ggplot2::ggplot()} plot.
}
\description{
\code{scale_y_continuous_hdx()} and the three variants with different \code{trans}
arguments are defaults scales for the y axis that ensures the distance
from data to the y-axis is reduced to 0, as is common throughout the HDX
data visualization guidelines. This is done by setting \code{expand = c(0, 0)}.
}
\details{
For simple manipulation of labels and limits, you may wish to use
\code{\link[ggplot2:labs]{labs()}} and \code{\link[ggplot2:lims]{lims()}} instead.
}
\examples{
library(ggplot2)

p <- ggplot(df_covid) +
  geom_line(
    aes(
      x = date,
      y = cases_monthly
    )
  )

p

# start y axis at 0
p + scale_y_continuous_hdx()
p + scale_y_log10_hdx()

}
