% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdx_geom_defaults.R
\name{ggplot2_geom_defaults}
\alias{ggplot2_geom_defaults}
\title{Default ggplot2 geometry aesthetics}
\usage{
ggplot2_geom_defaults()
}
\value{
A list of geometry defaults.
}
\description{
Default geometry aesthetics from the ggplot2 library. All of the aesthetics are the
standard ggplot2 defaults for those changed in \code{\link[=gghdx]{gghdx()}} based on
\code{\link[=hdx_geom_defaults]{hdx_geom_defaults()}}. Used in \code{\link[=gghdx_reset]{gghdx_reset()}} to return the plotting defaults
back to normal.
}
\details{
These aesthetics were manually pulled from ggplot2 from the geometries'
\code{default_aes} information, such as \code{ggplot2::GeomPoint$default_aes}. Since
the \code{default_aes} is changed after \code{\link[=gghdx]{gghdx()}} is run, the default geometries
in this function are hardcoded.
}
\examples{
library(purrr)
library(ggplot2)

# updating geom defaults (like default color of a point or fill for bar)
purrr::walk(
  hdx_geom_defaults(),
  ~ do.call(what = ggplot2::update_geom_defaults, args = .),
)

p <- ggplot(mtcars) +
  geom_point(
    aes(
      x = mpg,
      y = hp
    )
  )

# see the points are automatically in HDX sapphire
p

# need to reset back to the default geometries
purrr::walk(
  ggplot2_geom_defaults(),
  ~ do.call(what = ggplot2::update_geom_defaults, args = .)
)

# now the points are back to default black
p

}
