% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib.R
\name{fd_add}
\alias{fd_add}
\title{Add a ggplot object to the ggfigdone database}
\usage{
fd_add(
  name,
  g = last_plot(),
  fdObj = fd_get_db(),
  width = 10,
  height = 10,
  units = "cm",
  dpi = 200,
  overwrite = FALSE,
  id = uuid::UUIDgenerate()
)
}
\arguments{
\item{name}{A character string representing the figure name.}

\item{g}{A ggplot object.}

\item{fdObj}{An object of class \code{fdObj}.}

\item{width}{A numeric value specifying the width of the canvas.}

\item{height}{A numeric value specifying the height of the canvas.}

\item{units}{A character string indicating the units of the canvas.}

\item{dpi}{A numeric value denoting the dpi of the canvas.}

\item{overwrite}{A logical value. If set to TRUE, the function will overwrite the figure if it already exists. If set to FALSE, the function will terminate with an error message.}

\item{id}{A character string representing the figure ID. If not provided, the function will generate a random ID. Alternatively, an existing ID can be provided to update the corresponding figure.}
}
\value{
An object of class \code{fdObj}.
}
\description{
This function adds a ggplot object to the ggfigdone database. It can also be utilized to update an existing figure using its figure ID.
}
\examples{
library(ggplot2)

## Initial ggfigdone database using `fd_init`
db_dir = file.path(tempdir(), "fd_add_exp")
fo = fd_init(db_dir, rm_exist = TRUE)

## Draw a ggplot figure
g = ggplot(mtcars, aes(x=wt, y=mpg)) + geom_point()

## Add the figure to the database
fd_add(g = g, name  = "fig1", fo)

## Add the same figure with a different name
fd_add(g = g, name  = "fig2", fo)

## Show the updated ggfigdone database
print(fo)

}
