% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{StartNewsamples}
\alias{StartNewsamples}
\alias{run}
\title{Start new model fits}
\usage{
StartNewsamples(
  data,
  prior = NULL,
  nmc = 200,
  thin = 1,
  nchain = NULL,
  report = 100,
  rp = 0.001,
  gammamult = 2.38,
  pm_Hu = 0.05,
  pm_BT = 0.05,
  block = TRUE,
  ncore = 1,
  add = FALSE,
  is_old = FALSE
)

run(
  samples,
  nmc = 500,
  thin = 1,
  report = 100,
  rp = 0.001,
  gammamult = 2.38,
  pm_Hu = 0,
  pm_BT = 0,
  block = TRUE,
  ncore = 1,
  add = FALSE,
  is_old = TRUE
)
}
\arguments{
\item{data}{data model instance(s)}

\item{prior}{prior objects.  For hierarchical model, this must be a
list with three sets of prior distributions. Each is respectively named,
"pprior", "location", and "scale".}

\item{nmc}{number of Monte Carlo samples}

\item{thin}{thinning length}

\item{nchain}{number of chains}

\item{report}{progress report interval}

\item{rp}{tuning parameter 1}

\item{gammamult}{tuning parameter 2. This is the step size.}

\item{pm_Hu}{probability of migration type 0 (Hu & Tsui, 2010)}

\item{pm_BT}{probability of migration type 1 (Turner et al., 2013)}

\item{block}{Only for hierarchical modeling. A Boolean switch for update one
parameter at a time}

\item{ncore}{Only for non-hierarchical, fixed-effect models with many
subjects.}

\item{add}{Boolean whether to add new samples}

\item{is_old}{start sampling from a DMI or fit samples}

\item{samples}{posterior samples.}
}
\description{
Fit a hierarchical or a fixed-effect model, using Bayeisan
optimisation.  We use a specific type of pMCMC algorithm, the DE-MCMC. This
particular sampling method includes crossover and two different migration
operators. The migration operators are similar to random-walk algorithm.
They wouold be less efficient to find the target parameter space, if been
used alone.
}
