% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggdmcPrior.R
\name{plot_prior}
\alias{plot_prior}
\title{Visualise Distributions}
\usage{
plot_prior(p_prior, font_size = 5, cex = 5, return_data = FALSE)
}
\arguments{
\item{p_prior}{A list of distribution specifications. Each element should be
a list containing:
  \describe{
    \item{\code{dist}}{A character string specifying the distribution type.
      Supported values include: \code{"tnorm"}, \code{"beta"}, \code{"gamma"},
      \code{"lnorm"}, \code{"cauchy"}, \code{"unif"}, and \code{"norm"}.}
    \item{\code{p0}}{The first parameter of the distribution.}
    \item{\code{p1}}{The second parameter of the distribution (if applicable).}
    \item{\code{lower}}{Optional lower bound (used for truncated distributions).}
    \item{\code{upper}}{Optional upper bound (used for truncated distributions).}
    \item{\code{log_p}}{Logical indicating whether to compute log-densities.}
  }}

\item{font_size}{Numeric. Base font size for plot labels. Defaults to 5.}

\item{cex}{Numeric. Scaling factor for plot elements. Defaults to 5.}

\item{return_data}{Logical. If \code{TRUE}, returns the computed density data instead
of plotting. Defaults to \code{FALSE}.}
}
\value{
If \code{return_data = FALSE} (default), a lattice plot object is returned
displaying the density curves for each prior. If \code{return_data = TRUE}, a data
frame is returned with the following columns:
\itemize{
  \item \code{x}: Numeric vector of x-values generated for each prior using a heuristic.
  \item \code{y}: Corresponding density (or log-density) values.
  \item \code{gp}: Group label or parameter name for each distribution.
}
}
\description{
Plots density curves for specified distributions to help visualise
their shape and domain.
}
\details{
This function:
\itemize{
  \item Automatically determines appropriate x-axis ranges based on each distribution's properties.
  \item Handles both truncated and unbounded distributions.
  \item Supports all distribution types implemented in the package.
}

For truncated distributions, the density is plotted only within the specified bounds.
A heuristic is used to generate axis limits and labels using the internal
\code{generate_x_value} function.
}
\examples{
# Define a joint distribution
p_prior <- BuildPrior(
    p0 = c(A = 0.15, B = 0.45, mean_v = 2.25, sd_v = 0.15, t0 = 0.2),
    p1 = rep(0.1, 5),
    lower = rep(NA, 5),
    upper = rep(NA, 5),
    dist = rep("tnorm", 5),
    log_p = rep(FALSE, 5)
)

plot_prior(p_prior)

}
