% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{build_model_boolean_r}
\alias{build_model_boolean_r}
\title{Build Model Boolean}
\usage{
build_model_boolean_r(parameter_map_r, factors_r, accumulators_r, match_map_r)
}
\arguments{
\item{parameter_map_r}{An Rcpp::List where each element maps parameters
to conditions (character vector). The element names indicates
the model parameter. The element content is the factor name that
assocaites with a model parameter.  \code{1} represents no
assocation.}

\item{factors_r}{An Rcpp::List where each element defines factor levels
(character vector). Names should be factor names.}

\item{accumulators_r}{A character vector (std::vector<std::string>)
of accumulator names. I use `accumulator` to remind the
difference of the implicit accumulator and the manifested
response. Mostly, you may mix the two; however, sometimes,
merging the two concepts may result in conceptual errors.}

\item{match_map_r}{An Rcpp::List that defines the mapping between
stimuli and responses, specifying which response are considered correct
or incorrect. (This is a nested list structure).}
}
\value{
An R logical array with dimensions:
\itemize{
  \item 1st dimension: Parameters (column)
  \item 2nd dimension: Conditions (row)
  \item 3rd dimension: Responses  (slice)
}
Where `TRUE` indicates the model assumes that a model parameter (1st
dimension) affects a condition (2nd dimension) at a particular response
(3rd dimension).
}
\description{
Constructs a 3D boolean array indicating
parameter-condition-response association to represent the experimental
design.
}
\details{
The function:
\enumerate{
  \item Converts all R inputs to C++ maps for efficient processing
  \item Builds experimental design cells using \code{build_cell_names}
  \item Processes parameter-condition mappings with \code{add_M}
  \item Applies match map constraints to determine valid combinations
  \item Returns results as a 3D logical array compatible with R
}
}
\section{Typical Use Case}{

Used when you need to:
\itemize{
  \item Validate experimental design completeness
  \item Generate design matrices for model fitting
  \item Check response-condition constraints
}
}

\examples{
p_map <- list(A = "1", B = "1", mean_v = "M", sd_v = "1", st0 = "1",
              t0 = "1")
match_map <- list(M = list(s1 = "r1", s2 = "r2"))
factors <- list(S = c("s1", "s2"))
accumulators <- c("r1", "r2")
result <- build_model_boolean_r(p_map, factors, accumulators, match_map)

}
