% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polygons.R
\name{ob_polygon}
\alias{ob_polygon}
\title{The ob_polygon class}
\usage{
ob_polygon(
  p = S7::class_missing,
  label = character(0),
  vertex_radius = numeric(0),
  alpha = numeric(0),
  color = character(0),
  fill = character(0),
  linewidth = numeric(0),
  linetype = numeric(0),
  style = S7::class_missing,
  id = character(0),
  ...
)
}
\arguments{
\item{p}{\code{\link{ob_point}} or list of \code{\link{ob_point}} objects}

\item{label}{A character, angle, or \code{\link{ob_label}} object}

\item{vertex_radius}{A numeric or unit vector of length one, specifying the corner radius}

\item{alpha}{numeric value for alpha transparency}

\item{color}{character string for color}

\item{fill}{character string for fill color}

\item{linewidth}{Width of lines}

\item{linetype}{type of lines}

\item{style}{Gets and sets the styles associated with polygons}

\item{id}{character string to identify object}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> properties passed to style}
}
\value{
ob_polygon object
}
\description{
A polygon is specified with an \code{\link{ob_point}} that contains at least 3 points, the start and the end. Any number of intermediate points are possible.
}
\details{
If you wish to specify multiple polygons, you must supply a list of \code{\link{ob_point}} objects. When plotted, the ob_polygon function uses the \code{\link[ggforce:geom_shape]{ggforce::geom_shape}} function to create the geom.
}
\section{Slots}{

\describe{
\item{\code{length}}{The number of polygons in the ob_polygon object}

\item{\code{tibble}}{Gets a tibble (data.frame) containing parameters and styles used by \code{\link[ggforce:geom_shape]{ggforce::geom_shape}}.}
}}

