% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dark_mode.R
\name{dark_mode}
\alias{dark_mode}
\title{Activate dark mode on a 'ggplot2' theme}
\usage{
dark_mode(.theme = theme_get(), verbose = TRUE,
  force_geom_invert = FALSE)
}
\arguments{
\item{.theme}{ggplot2 theme object}

\item{verbose}{print messages (default: TRUE)}

\item{force_geom_invert}{Force the inversion of geom defaults for fill and color/colour (default: FALSE)}
}
\value{
dark version of theme
}
\description{
Activate dark mode on a 'ggplot2' theme
}
\examples{
library(ggplot2)

p1 <- ggplot(iris, aes(Sepal.Width, Sepal.Length, color = Species)) +
  geom_point()

p1  # theme returned by theme_get()
p1 + dark_mode()  # activate dark mode on theme returned by theme_get()

p2 <- ggplot(iris, aes(Sepal.Width, Sepal.Length)) +
  geom_point() +
  facet_wrap(~ Species)

p2 + dark_mode(theme_minimal())  # activate dark mode on another theme

invert_geom_defaults()  # restore geom defaults to their original values
}
