% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equal_count.R
\name{equal_count}
\alias{equal_count}
\title{The equal count algorithm}
\usage{
equal_count(df, vble, n_int = 6, frac = 0.5)
}
\arguments{
\item{df}{dataframe}

\item{vble}{numeric variable to be analized}

\item{n_int}{number of intervals}

\item{frac}{overlapping fraction}
}
\value{
a list with two elements:
\describe{
  \item{intervals}{a tibble where each rows referes to one of the generated interval, with its lower and upper limits, number of values in it and number of values overlapping with the next interval}
  \item{df_long}{a tibble in long format where each observation appears as many times as the number of intervals in which it belongs, with an identifier of the observation (`id`, its position in the original data.frame) and an identifier of the interval.}
  }
}
\description{
This function applies the equal count algorithm to divide a set of observations into intervals which can have certain level of ovelapping. It calls `lattice::equal.count` but extends the output.
}
\examples{
equal_count(iris, Sepal.Length, 15, 0.3)
}
