% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_pkg_gfont.R
\name{use_pkg_gfont}
\alias{use_pkg_gfont}
\title{Use a Google Font included in {gfonts}}
\usage{
use_pkg_gfont(
  font = c("roboto", "open-sans", "lato", "montserrat", "alegreya", "nunito-sans",
    "baloo", "happy-monkey", "henny-penny", "poppins", "oswald"),
  selector = "body"
)
}
\arguments{
\item{font}{Name of the font to use, possible choices are: \code{"roboto"},
\code{"open-sans"}, \code{"lato"}, \code{"montserrat"}, \code{"alegreya"},
\code{"nunito-sans"}, \code{"baloo"}, \code{"happy-monkey"}, \code{"henny-penny"}.}

\item{selector}{CSS selector for which to use the font,
usually an HTML tag, default to \code{"body"} (all document).}
}
\value{
An HTML tag with an \code{\link[htmltools]{htmlDependency}}.
}
\description{
For convenience, some fonts are included in the package,
 you can use them without having to download them, but only few variants are available.
}
\examples{
if (interactive()) {

  library(gfonts)
  library(htmltools)

  browsable(tags$div(
    use_pkg_gfont("open-sans"),
    tag_example(),
    tags$h1("First level title"),
    tags$h2("Second level title"),
    tags$h3("Third level title"),
    tags$h4("Fourth level title"),
    tags$h5("Fifth level title"),
    tags$h6("Sixth level title")
  ))


  browsable(tags$div(
    use_pkg_gfont("henny-penny"),
    tag_example(),
    tags$h1("First level title"),
    tags$h2("Second level title"),
    tags$h3("Third level title"),
    tags$h4("Fourth level title"),
    tags$h5("Fifth level title"),
    tags$h6("Sixth level title")
  ))

}
}
