% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparisons.R
\name{rmse_calculate}
\alias{rmse_calculate}
\title{Calculate RMSE for Covariate, Outcome, and Competing Risk Models}
\usage{
rmse_calculate(i, fits, covnames, covtypes)
}
\arguments{
\item{i}{Integer specifying the index of \code{fits}.}

\item{fits}{List of fitted models.}

\item{covnames}{Vector of character strings specifying the names of the time-varying covariates in \code{obs_data}.}

\item{covtypes}{Vector of character strings specifying the "type" of each time-varying covariate included in \code{covnames}. The possible "types" are: \code{"binary"}, \code{"normal"}, \code{"categorical"}, \code{"bounded normal"}, \code{"zero-inflated normal"}, \code{"truncated normal"}, \code{"absorbing"}, \code{"categorical time"}, and \code{"custom"}.}
}
\value{
The RMSE for the model.
}
\description{
This internal function calculates root mean square error (RMSE) for the covariate (and the outcome and competing event, if applicable) models fit on
the observed data.
}
\keyword{internal}
