% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotScatterPie.R
\name{plotScatterPie}
\alias{plotScatterPie}
\title{plotScatterPie}
\usage{
plotScatterPie(
  data,
  pieRange,
  pieColor = NULL,
  xmeanLine = TRUE,
  ymeanLine = TRUE,
  label_on = TRUE,
  output = FALSE
)
}
\arguments{
\item{data}{a dataframe with colnames x, y, r, label, these four names must be in colnames.}

\item{pieRange}{define which column to which column to be presented by pie chart, see examples}

\item{pieColor}{color for different colors in pie chart}

\item{xmeanLine}{if plot x mean line}

\item{ymeanLine}{if plot y mean line}

\item{label_on}{Whether to show label}

\item{output}{if you want an ggplot object as output, default is FALSE}
}
\description{
plot scatter pie chart for multidimension analysis, such as waternomics. This plot can
provide information about water use/wastewater of each provinces and GDP mix of each provinces,
see examples.
}
\examples{


GDPColor_CWR <- c("#6B8033", "#020303", "#0D77B9")


data(GDPmix)

# in colnames(GDPmix), there must be x, y, r, label.
# but right now, GDPmix has x, y, r, but lacks a label column, let's assign label to province column
colnames(GDPmix)[1] <- 'label'

\dontrun{
plotScatterPie(GDPmix, pieRange = 4:6, pieColor = GDPColor_CWR)
}



}
