% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_draw_table.R
\name{draw_table}
\alias{draw_table}
\title{Helper function to draw table grobs.}
\usage{
draw_table(body, heading, ...)
}
\arguments{
\item{body}{A dataframe. Table body.}

\item{heading}{A string. Table title.}

\item{...}{Further arguments to control the gtable.}
}
\description{
\code{draw_table()} Pre and post version: 2.0.0 gridExtra packages
handle drawing tables differently. \code{draw_table()} determines
the installed version of gridExtra and applies the appropriate
syntax. If gridExtra version < 2.0.0 then it uses old gridExtra 
syntax to build table Grob(graphical object) else uses new syntax. 
\code{draw_table()}
}
\details{
prints tables without rownames.
}
\section{Acknowledgements}{
 Thanks to Ryan Welch, 
https://github.com/welchr/LocusZoom/issues/16
}

\examples{

library(gridExtra)

\dontrun{

# Table of iris values
iris_dframe <- head(iris)
title_iris_dframe <- paste("Table: Length and width measurements (cm) of sepals and petals,",
                            "for 50 flowers from 3 species of iris (setosa, versicolor,", 
                            "and virginica).\n", sep = " ")
# Wrap title text at column 60
title_iris_dframe <- sapply(strwrap(title_iris_dframe, width = 60, simplify = FALSE), 
                            paste, collapse = "\n")
# Draw table
table_influential_studies <- draw_table(body = iris_dframe, heading = title_iris_dframe)

# Table of mtcars values
mtcars_dframe <- head(mtcars)
title_mtcars_dframe <- paste("Table: Motor Trend US magazine (1974) automobile statistics", 
                             "for fuel consumption, \nautomobile design and performance.\n", 
                             sep = " ")
# Wrap title text at column 60
title_mtcars_dframe <- sapply(strwrap(title_mtcars_dframe, width = 60, simplify = FALSE), 
                              paste, collapse = "\n")
# Draw table
table_influential_studies <- draw_table(body = mtcars_dframe, heading = title_mtcars_dframe)
}
}
