% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gboot_cloud.R
\name{gboot_cloud}
\alias{gboot_cloud}
\title{Bootstrap of the variogram cloud}
\usage{
gboot_cloud(data,var,model,B)
}
\arguments{
\item{data}{object of the class geodata.}

\item{var}{object of the class variogram.}

\item{model}{object of the class variomodel.}

\item{B}{number of the bootstrap that will be performed (default B=1000).}
}
\value{
\bold{variogram_boot} gives the variogram of each bootstrap.

\bold{variogram_or} gives the original variogram.

\bold{pars_boot} gives the estimatives of the nugget, sill, contribution, range and practical range for each bootstrap.

\bold{pars_or} gives the original estimatives of the nugget, sill, contribution, range and practical range.

Invalid arguments will return an error message.
}
\description{
Performs a boostrap based on the variogram cloud
}
\details{
The variogram cloud is computed by the function \code{\link[geoR]{variog}}.
It provides all the possible pairs that will generate the classical variogram.
The algorithm performs a classical bootstrap in each lag of the variogram.
The steps are:

\enumerate{
\item Calculate the variogram cloud;
\item Obtain the number of lags (See details in \code{\link[geoR]{variog}}: defining the bins);
\item Sample with replacement in each lag;
\item Create a new variogram using the average of all pairs in each lag;
\item Calculate and save the statistics of interest;
\item Return to step 3 and repeat the process at least 1000 times.
}
}
\examples{

\donttest{
# Example 1

## transforming the data.frame in an object of class geodata
data<- as.geodata(soilmoisture)

points(data) ## data visualization

var<- variog(data, max.dist = 140) ## Obtaining the variogram
plot(var)

## Fitting the model
mod<- variofit(var,ini.cov.pars = c(2,80),nugget = 2,cov.model = "sph")
lines(mod, col=2, lwd=2) ##fitted model

## Bootstrap procedure

boot<- gboot_cloud(data,var,mod,B=10)
## For better Confidence interval, try B=1000

gboot_CI(boot,digits = 4) ## Bootstrap Confidence Interval

gboot_plot(boot) ## Bootstrap Variogram plot

# Example 2

## transforming the data.frame in an object of class geodata
data<- as.geodata(NVDI)

points(data) ## data visualization

var<- variog(data, max.dist = 18) ## Obtaining the variogram
plot(var)

## Fitting the model
mod<- variofit(var,ini.cov.pars = c(0.003,6),nugget = 0.003,cov.model = "gaus")
lines(mod, col=2, lwd=2) ##fitted model

## Bootstrap procedure

boot<- gboot_cloud(data,var,mod,B=10)
## For better Confidence interval, try B=1000

gboot_CI(boot,digits = 4) ## Bootstrap Confidence Interval

gboot_plot(boot) ## Bootstrap Variogram plot
}
}
\author{
Diogo Francisco Rossoni \email{dfrossoni@uem.br}

Vinicius Basseto Felix \email{felix_prot@hotmail.com}
}
\keyword{Bootstrap}
\keyword{Cloud}
\keyword{Spatial}
\keyword{Variogram}
