% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{logit}
\alias{logit}
\alias{logit.default}
\alias{logit.density}
\title{logistic transformation}
\usage{
logit(x, ...)

\method{logit}{default}(x, inverse = FALSE, ...)

\method{logit}{density}(x, inverse = TRUE, ...)
}
\arguments{
\item{x}{a vector of real numbers (strictly positive if
\code{inverse=FALSE}) or an object of class \code{density}.}

\item{...}{optional arguments to the \code{log} function.}

\item{inverse}{logical. If \code{inverse=FALSE}, returns
\eqn{\ln\!\left[\frac{x}{1-x}\right]}; otherwise returns
\eqn{\frac{\exp[x]}{\exp[x]+1}}.}
}
\value{
a vector with the same length of \code{x}
}
\description{
Maps numbers from [0,1] to [\eqn{-\infty,+\infty}] and
    back.
}
\examples{
data(catchments,package='geostats')
lp <- logit(catchments$vegetation/100,inverse=FALSE)
ld <- density(lp)
d <- logit(ld,inverse=TRUE)
plot(d)
}
