% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile_points.R
\name{profile_points}
\alias{profile_points}
\title{Profile End Point}
\usage{
profile_points(
  start,
  profile.azimuth,
  profile.length,
  crs = st_crs(start),
  return.sf = TRUE
)
}
\arguments{
\item{start}{\code{sf} point object.}

\item{profile.azimuth}{numeric or \code{units} object. Direction of profile in
degrees if numeric.}

\item{profile.length}{numeric or \code{units} object.}

\item{crs}{Coordinate reference system. Should be parsed by \code{\link[sf:st_crs]{sf::st_crs()}}.}

\item{return.sf}{logical. Should the profile points be returned as a \code{sf}
object (\code{TRUE}, the default) object or as a data.frame.}
}
\value{
class depends on \code{return.sf}.
}
\description{
Create a end point along a profile line starting at a point with a defined
direction and length.
}
\note{
Use metric values (meters, kilometers, etc) in case of a projected coordinate
reference frame, and degree
when geographical coordinate reference frame.
}
\examples{
p1 <- data.frame(lon = -90.8, lat = 48.6) |>
  sf::st_as_sf(coords = c("lon", "lat"), crs = "WGS84")
profile_points(p1,
  profile.azimuth = 135, profile.length = units::set_units(10, "km"),
  crs = sf::st_crs("EPSG:26915")
)
}
