% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{profile_coords}
\alias{profile_coords}
\title{Profile Coordinates}
\usage{
profile_coords(x, profile, azimuth = NULL, drop.units = TRUE)
}
\arguments{
\item{x}{\code{'sf'} object}

\item{profile}{\code{'sf'} object of the profile or the profile's starting point.}

\item{azimuth}{numeric. Direction (in degrees) emanating from starting point.
Is ignored when \code{profile} contains two points or is a \code{LINESTRING}.}

\item{drop.units}{logical. Whether the return should show the units or not.}
}
\value{
\code{tibble} where \code{X} is the distance along the profile line.
\code{Y} is the distance across the profile line. (units of \code{X} and \code{Y} depend on
coordinate reference system).
}
\description{
Project points on a cross section given by a starting point and the direction
}
\examples{
data(locations_example)
p1 <- data.frame(lon = -90.8, lat = 48.6) |>
  sf::st_as_sf(coords = c("lon", "lat"), crs = "WGS84")
profile_crds <- profile_coords(locations_example, profile = p1, azimuth = 135)
head(profile_crds)

# Plot the transformed coordinates
plot(profile_crds)
}
\author{
Tobias Stephan
}
