% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_fda.R
\name{geo_fda}
\alias{geo_fda}
\title{Geostatistical estimates for function-valued data.}
\usage{
geo_fda(
  m_data,
  m_coord,
  new_coord,
  m,
  n_quad = 20,
  t = seq(from = -pi, to = pi, length.out = 1000)
)
}
\arguments{
\item{m_data}{a matrix where each column is a time series in a location}

\item{m_coord}{a matrix with coordinates (first column is latitude and
second column longitude)}

\item{new_coord}{a vector with a new coordinate (first column is latitude
and second longitude)}

\item{m}{order of the Fourier polynomial}

\item{n_quad}{a scalar with number of quadrature points. Default value
\code{nquad = 20}.}

\item{t}{a vector with points to evaluate from \eqn{-\pi} to \eqn{\pi}.
Default \code{t = seq(from = -pi,to = pi,length.out = 1e+3)}.}
}
\value{
a list with three components
\describe{
\item{\code{curve}}{estimate curve at \code{t} points}
\item{\code{lambda}}{weights in the linear combination in the functional
kriging}
\item{\code{x}}{points where the curve was evaluated}
}
}
\description{
\code{geo_fda} finds the ordinary kriging estimate for sptial functional
data using the model proposed by Giraldo(2011).
}
\details{
\code{geo_fda} is similar to model proposed by
\cite{giraldo2011ordinary}. The mais difference is we have used
gauss-legendre quadrature to estimate the trace-variogram. Using
gauss-legendre qudrature gives estimates with smaller mean square error
than the trace-variogram estimates from Giraldo(2011).

For now, we have used Fourier's series to smooth the time series.
}
\examples{
data(canada)

y_hat <- geo_fda(canada$m_data, canada$m_coord, canada$ThePas_coord,
n_quad = 2)
}
\references{
Giraldo, R., Delicado, P., & Mateu, J. (2011). Ordinary kriging
for function-valued spatial data. \emph{Environmental and Ecological
Statistics}, 18(3), 411-426.

Giraldo, R., Mateu, J., & Delicado, P. (2012). geofd: an \code{R} package
for function-valued geostatistical prediction.
\emph{Revista Colombiana de Estadística}, 35(3), 385-407.
}
\seealso{
\code{\link{coef_fourier}}, \code{\link{fourier_b}}
}
