% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spcovariance.R
\name{spcovariance}
\alias{spcovariance}
\alias{spcovariance.formula}
\alias{spcovariance.numeric}
\alias{spcovariance.dist}
\title{Spatial variance-covariance matrix}
\usage{
spcovariance(...)

\method{spcovariance}{formula}(
  formula,
  data,
  subset,
  corrfcn,
  ssq,
  phi,
  omg,
  kappa,
  longlat = FALSE,
  ...
)

\method{spcovariance}{numeric}(x, corrfcn, ssq, phi, omg, kappa, ...)

\method{spcovariance}{dist}(x, corrfcn, ssq, phi, omg, kappa, ...)
}
\arguments{
\item{...}{Further arguments. Not currently in use.}

\item{formula}{A formula of the form \code{~ Xcoord + Ycoord}
specifying the sampled locations.}

\item{data}{An optional data frame containing the variables in the
model.}

\item{subset}{An optional set of indices. The covariance will be
calculated for those coordinates only.}

\item{corrfcn}{The correlation function to use.}

\item{ssq}{The partial sill parameter.}

\item{phi}{The spatial range parameter.}

\item{omg}{The relative nugget parameter.}

\item{kappa}{The spatial smoothness parameter.}

\item{longlat}{How to compute the distance between locations. If
\code{FALSE}, Euclidean distance, if \code{TRUE} Great Circle
distance. See \code{\link[sp]{spDists}}.}

\item{x}{A numerical object of distances.}
}
\value{
For a formula input, a variance-covariance matrix. For a
  numeric input, an object of the the same dimensions as its first
  input.
}
\description{
Calculates the spatial variance-covariance matrix for a selection
of correlation functions.
}
