% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Score_init.R
\name{ran_mat}
\alias{ran_mat}
\title{Random generator of matrices with given eigenvalues.}
\usage{
ran_mat(p, ev = stats::runif(p, 0, 10), seed = NULL)
}
\arguments{
\item{p}{A positive integer >= 2, the dimension.}

\item{ev}{A vector of length \code{p}, the eigenvalues of the output matrix.}

\item{seed}{A number, the seed for the generator. Ignored if \code{NULL}.}
}
\value{
A \code{p} by \code{p} matrix whose eigenvalues equal to \code{ev}.
}
\description{
Random generator of matrices with given eigenvalues.
}
\details{
The function randomly fills a \code{p} by \code{p} matrix with independent \eqn{Normal(0,1)} entries, takes the \code{Q} matrix from its \code{QR} decomposition, and returns \eqn{Q' diag(ev) Q}.
}
\examples{
p <- 30
eigen_values <- (0.1*p-1+1:p)/p
K <- ran_mat(p, ev=eigen_values, seed=1)
sort(eigen(K)$val)-eigen_values
}
