% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood_calc_function.R
\name{calc.like}
\alias{calc.like}
\title{Function to Calculate Log Likelihood for a Logistic Regression Model}
\usage{
calc.like(beta, t, model)
}
\arguments{
\item{beta}{Vector of logistic regression coefficients.}

\item{t}{A 2x3 table of joint probabilities of disease and genotype.  Rows = case vs. control, columns=genotype.}

\item{model}{The genetic model in the logistic regression: "Dominant", "Additive", "Recessive", "2df" or "null"}
}
\value{
The log likelihood.
}
\description{
Convenience function to calculate the log likelihood of a specified model.
}
\examples{
t <- rbind(c(0.2967437, 0.1806723, 0.02258404), 
 c(0.3432563, 0.1393277, 0.01741596))
calc.like(logistic.mles(t, "Dominant"), t, model="Dominant")

}
