% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutation.R
\name{gena.mutation}
\alias{gena.mutation}
\title{Mutation}
\usage{
gena.mutation(
  children,
  lower,
  upper,
  prob = 0.2,
  prob.genes = 1/nrow(children),
  method = "constant",
  par = 1,
  iter = NULL
)
}
\arguments{
\item{children}{numeric matrix which rows are children i.e. vectors of 
parameters values.}

\item{lower}{lower bound of the search space.}

\item{upper}{upper bound of the search space.}

\item{prob}{probability of mutation for a child.}

\item{prob.genes}{numeric vector or numeric value representing the
probability of mutation of a child's gene. See 'Details'.}

\item{method}{mutation method to be used for transforming genes of children.}

\item{par}{additional parameters to be passed depending on the \code{method}.}

\item{iter}{iteration number of the genetic algorithm.}
}
\value{
The function returns a matrix which rows are children
(after mutation has been applied to some of them).
}
\description{
Mutation method (algorithm) to be used in the
genetic algorithm.
}
\details{
Denote \code{children} by \eqn{C^{child}} which \code{i}-th row 
\code{children[i, ]} is a chromosome \eqn{c_{i}^{child}} i.e. the vector of 
parameter values of the function being optimized \eqn{f(.)} that is
provided via \code{fn} argument of \code{\link[gena]{gena}}.
The elements of chromosome \eqn{c_{ij}^{child}} are genes 
representing parameters values.

Mutation algorithm determines random transformation of children's genes. 
Each child may be selected for mutation with probability \code{prob}.
If \eqn{i}-th child is selected for mutation and \code{prob.genes} is a 
vector then \eqn{j}-th gene of this child
is transformed with probability \code{prob.genes[j]}. If \code{prob.genes}
is a constant then this probability is the same for all genes.

Argument \code{method} determines particular mutation algorithm to 
be applied. Denote by \eqn{\tau} the vector of parameters used by the 
algorithm. Note that \eqn{\tau} corresponds to \code{par}.
Also let's denote by \eqn{c_{ij}^{mutant}} the value of 
gene \eqn{c_{ij}^{child}} after mutation.

If \code{method = "constant"} then \eqn{c_{ij}^{mutant}}
is a uniform random variable between \code{lower[j]} and \code{upper[j]}.

If \code{method = "normal"} then \eqn{c_{ij}^{mutant}}
equals to the sum of \eqn{c_{ij}^{child}} and normal random variable
with zero mean and standard deviation \code{par[j]}. 
By default \code{par} is identity vector of length \code{ncol(children)}
so \code{par[j] = 1} for all \code{j}.

If \code{method = "percent"} then \eqn{c_{ij}^{mutant}} is generated 
from \eqn{c_{ij}^{child}}  by equiprobably increasing or decreasing it 
by \eqn{q} percent,
where \eqn{q} is a uniform random variable between \eqn{0} and \code{par[j]}. 
Note that \code{par} may also be a constant then all
genes have the same maximum possible percentage change.
By default \code{par = 20}.

For more information on mutation algorithms
please see Patil, Bhende (2014).
}
\examples{
# Randomly initialize some children
set.seed(123)
children.n <- 10
children <- gena.population(pop.n = children.n,
                            lower = c(-5, -5), 
                            upper = c(5, 5))
                           
# Perform the mutation
mutants <- gena.mutation(children = children,
                         prob = 0.6,
                         prob.genes = c(0.7, 0.8),
                         par = 30,
                         method = "percent")
print(mutants)
}
\references{
S. Patil, M. Bhende. (2014). 
Comparison and Analysis of Different Mutation Strategies to improve the 
Performance of Genetic Algorithm.
\emph{International Journal of Computer Science and 
Information Technologies}, 5 (3), 4669-4673.
}
