% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{gemini_request}
\alias{gemini_request}
\title{Send POST request to Gemini API}
\usage{
gemini_request(url, body)
}
\arguments{
\item{url}{Character. The Gemini API endpoint URL.}

\item{body}{List. The request body to send as JSON.}
}
\value{
Character string containing the API response.
}
\description{
Sends a POST request to the Gemini API with the specified URL and body, and returns the response as a character string.
}
\examples{
\dontrun{
body <- list(contents = list(list(parts = list(list(text = "Hello!")))))
gemini_request(
  paste0("https://generativelanguage.googleapis.com/v1beta/models/",
     "gemini-2.5-flash-image-preview:generateContent"), body)
}
}
\keyword{internal}
