\name{bmt}
\alias{bmt}
\docType{data}
\title{
Bone marrow transplantation data
}
\description{
This multi-center acute leukemia study consists of 137 patients with acute myelocytic leukemia (AML) or acute lymphoblastic leukemia (ALL) aged 7 to 52 from March 1, 1984 to June 30, 1989 at four institutions (Klein and Moeschberger, 2003). The failure time on study is defined at time (in days) to relapse or death.}
\usage{data(bmt)}
\format{The variables represented in the data set are as follows:
  \describe{
  \item{\code{g}}{Disease group: 1 - All, 2 - AML Low Risk, 3 - AML High Risk.}
  \item{\code{T1}}{Time to death or on study time.}
  \item{\code{T2}}{Disease free survival time (time to relapse, death or end of study).}
  \item{\code{d1}}{Death indicator: 1 - Dead, 0 - Alive.}
  \item{\code{d2}}{Relapse indicator: 1 - Relapsed, 0 - Disease Free.}
  \item{\code{d3}}{Disease free survival indicator: 1 - Dead or Relapsed, 0 - Alive Disease Free.}
  \item{\code{TA}}{Time to Acute Graft-Versus-Host Disease.}
  \item{\code{da}}{Acute GVHD indicator: 1 - Developed Acute GVHD, 0 - Never Developed Acute GVHD.}
  \item{\code{TC}}{Time to Chronic Graft-Versus-Host Disease.}
  \item{\code{dc}}{Chronic GVHD Indicator: 1 - Developed Chronic GVHD, 0 - Never Developed Chronic GVHD.}
  \item{\code{TP}}{Time to return of platelets to normal levels.}
  \item{\code{dp}}{Platelet recovery indicator: 1 - platelets returned to normal, 0 - platelets never returned to normal.}
  \item{\code{Z1}}{Patient age in years.}
  \item{\code{Z2}}{Donor age in years.}
  \item{\code{Z3}}{Patient sex: 1 - Male, 0 - Female.}
  \item{\code{Z4}}{Doner sex: 1 - Male, 0 - Female.}
  \item{\code{Z5}}{Patient CMV status: 1 - CMV positive, 0 - CMV negative.}
  \item{\code{Z6}}{Donor CMV status: 1 - CMV positive, 0 - CMV negative.}
  \item{\code{Z7}}{Waiting time to transplant in days.}
  \item{\code{Z8}}{FAB: 1 - FAB Grade 4 or 5 and AML, 0 - otherwise.}
  \item{\code{Z9}}{Hospital: 1 - The Ohio State University, 2 - Alferd , 3 - St. Vincent, 4 - Hahnemann.}
  \item{\code{Z10}}{MTX: used as a Graft-Versus-Host-Prophylactic 1 - Yes, 0 - No.}  
  }
}
\references{
Klein, J. P. and Moeschberger, M. L. (2003) \emph{Survival Analysis: Techniques for Censored and Truncated Data}. Springer, New York, 2nd edition.
}
\keyword{datasets}