% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blc_sm.R
\name{phase_shift}
\alias{phase_shift}
\title{Phase shift}
\usage{
phase_shift(data, shift)
}
\arguments{
\item{data}{a \emph{list} object. Data extracted from a cdf file,
ideally the output from extract_data().}

\item{shift}{a \emph{float} object. The number of seconds to shift the phase
by.}
}
\value{
A \emph{data.frame} object. A list of two data frames. A TIC data
frame and an MS data frame.
}
\description{
\code{phase_shift} shifts the phase of the chromatogram.
}
\details{
This function shifts the phase of the chromatogram up or down by
the specified number of seconds.
}
\examples{
file <- system.file("extdata","sample1.cdf",package="gcxgclab")
frame <- extract_data(file,mod_t=.5)
shifted <- phase_shift(frame, -.2)
plot_chr(shifted, title='Shifted')

}
