% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gclm.R
\name{gclm}
\alias{gclm}
\alias{gclm.path}
\title{l1 penalized loss estimation for GCLM}
\usage{
gclm(
  Sigma,
  B = -0.5 * diag(ncol(Sigma)),
  C = rep(1, ncol(Sigma)),
  C0 = rep(1, ncol(Sigma)),
  loss = "loglik",
  eps = 0.01,
  alpha = 0.5,
  maxIter = 100,
  lambda = 0,
  lambdac = 0,
  job = 0
)

gclm.path(
  Sigma,
  lambdas = NULL,
  B = -0.5 * diag(ncol(Sigma)),
  C = rep(1, ncol(Sigma)),
  ...
)
}
\arguments{
\item{Sigma}{covariance matrix}

\item{B}{initial B matrix}

\item{C}{diagonal of initial C matrix}

\item{C0}{diagonal of penalization matrix}

\item{loss}{one of "loglik" (default) or "frobenius"}

\item{eps}{convergence threshold}

\item{alpha}{parameter line search}

\item{maxIter}{maximum number of iterations}

\item{lambda}{penalization coefficient for B}

\item{lambdac}{penalization coefficient for C}

\item{job}{integer 0,1,10 or 11}

\item{lambdas}{sequence of lambda}

\item{...}{additional arguments passed to \code{gclm}}
}
\value{
for \code{gclm}: a list with the result of the optimization

for \code{gclm.path}: a list of the same length of
\code{lambdas} with the results of the optimization for
the different \code{lambda} values
}
\description{
Estimates a sparse continuous time Lyapunov
parametrization of a covariance matrix using a lasso
(L1) penalty.
}
\details{
\code{gclm} performs proximal gradient descent for the optimization problem
\deqn{argmin L(\Sigma(B,C)) + \lambda \rho(B) + \lambda_C ||C - C0||_F^2}
subject to \eqn{B} stable and \eqn{C} diagonal, where \eqn{\rho(B)} is the l1 norm
of the off-diagonal element of \eqn{B}.

\code{gclm.path} simply calls iteratively \code{gclm}
with different \code{lambda} values. Warm start is used, that
is in the i-th call to \code{gclm} the \code{B} and \code{C}
matrices are initialized as the one obtained in the (i-1)th
call.
}
\examples{
x <- matrix(rnorm(50*20),ncol=20)
S <- cov(x)

## l1 penalized log-likelihood
res <- gclm(S, eps = 0, lambda = 0.1, lambdac = 0.01)

## l1 penalized log-likelihood with fixed C
res <- gclm(S, eps = 0, lambda = 0.1, lambdac = -1)

## l1 penalized frobenius loss
res <- gclm(S, eps = 0, lambda = 0.1, loss = "frobenius")
}
