% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{seq_data}
\alias{seq_data}
\title{Genomic Sequence Data with Annotations}
\format{
A data frame with multiple rows and 2 variables:
\describe{
\item{SeqName}{Character. Combined annotation fields separated by semicolons, containing:
\itemize{
\item \code{ID}: Sequence identifier (e.g., "1_7")
\item \code{partial}: Completion status ("00" for complete, "01" for partial)
\item \code{start_type}: Translation initiation codon (e.g., "GTG", "ATG")
\item \code{rbs_motif}: Ribosome binding site motif (e.g., "GGAG/GAGG")
\item \code{rbs_spacer}: RBS spacer length (e.g., "5-10bp")
\item \code{gc_cont}: GC content (e.g., "0.673")
}
}
\item{Sequence}{Character. DNA sequence (when available) in FASTA format}
}
}
\usage{
seq_data
}
\description{
A dataset containing DNA sequences from test bacteria with detailed annotation metadata.
The first column combines multiple annotation elements separated by semicolons.
}
\keyword{datasets}
