% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gc_plot.R
\name{gc_plot}
\alias{gc_plot}
\title{Plot Scaled Gene Clusters with Arrows}
\usage{
gc_plot(
  data = GC_meta,
  color_theme = c("#3BAA51", "#6495ED", "#DD2421", "#EF9320", "#F8EB00", "#FF0683",
    "#956548", "grey")
)
}
\arguments{
\item{data}{A data frame produced by \code{\link{gc_scale}}, must include
the columns \code{Pstart}, \code{Pend}, \code{Pgenome},
\code{gene_group}, \code{Pdirection}, and
\code{gene_label}.}

\item{color_theme}{Character vector of colours, \strong{in the same order} as the
factor levels of \code{gene_group}.  Defaults to an
8-colour palette; supply fewer or more colours as needed.}
}
\value{
A \code{ggplot} object that can be further customised or printed.
The plot uses \code{gggenes::geom_gene_arrow()} and
\code{gggenes::geom_gene_label()} with the following elements:
\itemize{
\item One facet per \code{Pgenome} (cluster).
\item Genes coloured by \code{gene_group}.
\item Arrow direction encoded by \code{Pdirection}.
\item Optional gene labels inside arrows.
}
}
\description{
Generates a compact, publication-ready arrow plot of gene
clusters previously processed with \code{\link{gc_scale}}.
Each cluster is displayed on its own horizontal track, with
gene directionality, labels, and user-defined colour schemes.
}
