% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funs.R
\name{init}
\alias{init}
\alias{trigger}
\alias{watch}
\title{Initiate, triger, event}
\usage{
init(..., session = getDefaultReactiveDomain())

trigger(..., session = getDefaultReactiveDomain())

watch(name, session = getDefaultReactiveDomain())
}
\arguments{
\item{session}{The shiny session object}

\item{name, ...}{The name(s) of the events}
}
\value{
The `session` object invisibly.
These functions are mainly used for side-effects.
}
\description{
Initiate, triger, event
}
\examples{
if (interactive()){
  library(shiny)
  library(gargoyle)
  options("gargoyle.talkative" = TRUE)
  ui <- function(request){
    tagList(
      h4('Go'),
      actionButton("y", "y"),
      h4('Output of z$v'),
      tableOutput("evt")
    )
  }

  server <- function(input, output, session){

    # Initiating the flags
    init( "plop", "pouet", "poum")

    # Creating a new env to store values, instead of
    # a reactive structure
    z <- new.env()

    observeEvent( input$y , {
      z$v <- mtcars
      # Triggering the flag
      trigger("airquality")
    })

    on("airquality", {
      # Triggering the flag
      z$v <- airquality
      trigger("iris")
    })

    on("iris", {
      # Triggering the flag
      z$v <- iris
      trigger("renderiris")
    })

    output$evt <- renderTable({
      # This part will only render when the renderiris
      # flag is triggered
      watch("renderiris")
      head(z$v)
    })

  }

  shinyApp(ui, server)

}
}
