% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galilean_satellites.R
\name{galsat}
\alias{galsat}
\title{Calculate & draw the positions of the Galilean satellites}
\usage{
galsat(year, month, day, hour, minute)
}
\arguments{
\item{year}{Type in the year (integer number from 0 to 3000).}

\item{month}{Type in the month (integer number from 1 to 12).}

\item{day}{Type in the day (integer number from 1 to 31).}

\item{hour}{Type in the hour (integer number from 0 to 23).}

\item{minute}{Type in the minute (integer number from 0 to 59).}
}
\value{
\code{data.frame}: 4 observations of 4 variables:
$ moon       : chr "Io" "Europa" "Ganymede" "Callisto"
$ x          : num
$ y          : num
$ u_corrected: num
Four rows - each row has the position (x,y) and corrected angular position (u_corrected) of one moon.
Additionally, the positions of the moons are shown graphically.
}
\description{
\code{galsat()} is used to determine the positions of the four greatest satellites
of Jupiter (called Galilean satellites). Positions are shown on the plot for
given UTC time (Coordinated Universal Time between year 0 and 3000) with respect
to the planet, as seen from the Earth.

The \code{galsat()} function returns numerical values of the satellites' positions:

x - the apparent rectangular coordinate of the satellite with respect to the
center of Jupiter's disk in the equatorial plane in the units of Jupiter's
equatorial radius; X is positive toward the west

y - the apparent rectangular coordinate of the satellite with respect to the
center of Jupiter's disk from the equatorial plane in the units of Jupiter's
equatorial radius; Y is positive toward the north

u_corrected - the corrected angular position of the satellite in degrees,
used to determine visibility conditions (whether a moon can be seen against
Jupiter's disk or is hidden behind it)
}
\details{
The function is based on algorithms in the book:
Astronomical Formulae for Calculators (4th edition), Jean Meeus, Willmann-Bell Inc., 1988
}
\examples{
galsat(2025, 10, 13, 23, 30)
# Also try these interesting configuration moments:
galsat(2021, 8, 15, 15, 48)
galsat(2032, 1, 5, 6, 44)
galsat(2033, 7, 28, 4, 50)
galsat(2039, 7, 31, 18, 55)
}
