% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{lifespan}
\alias{lifespan}
\title{Simulated Dataset with Lifespan Trajectories of Three Cognitive Domains}
\format{
\subsection{\code{lifespan} A data frame with 54,457 rows and 7 columns:}{

\describe{
\item{id}{Subject ID.}
\item{domain}{Cognitive domain being measured. One of \code{"epmem"} for
episodic memory, \code{"wmem"} for working memory and \code{"execfun"} for
executive function/speed.}
\item{timepoint}{Integer indicating the timepoint number.}
\item{age}{Age of participant at the timepoint.}
\item{test}{The particular test at this observation.}
\item{y}{Response. For \code{"epmem"} and \code{"wmem"} this is the number
of successes in 16 trials. For \code{"execfun"} it is the time in seconds
to complete the task.}
\item{retest}{Integer indicating whether the participant has taken the test
at a previous timepoint.}
\item{domainepmem}{Dummy variable for \code{domain=="epmem"}.}
\item{domainwmem}{Dummy variable for \code{domain=="wmem"}.}
\item{domainexecfun}{Dummy variable for \code{domain=="execfun"}.}
}
}
}
\usage{
lifespan
}
\description{
This dataset is simulated based on the data used in Section 4.1 of
\insertCite{sorensenLongitudinalModelingAgeDependent2023;textual}{galamm}.
}
\references{
\insertAllCited{}
}
\seealso{
Other datasets: 
\code{\link{cognition}},
\code{\link{diet}},
\code{\link{epilep}},
\code{\link{hsced}},
\code{\link{latent_covariates}},
\code{\link{latent_covariates_long}},
\code{\link{mresp}},
\code{\link{mresp_hsced}}
}
\concept{datasets}
\keyword{datasets}
