% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_all.R
\name{search_all}
\alias{search_all}
\alias{search_atlases}
\alias{search_reasons}
\alias{search_ranks}
\alias{search_fields}
\alias{search_assertions}
\alias{search_profiles}
\alias{search_providers}
\alias{search_collections}
\alias{search_datasets}
\alias{search_licences}
\alias{search_apis}
\alias{search_identifiers}
\alias{search_lists}
\alias{search_taxa}
\title{Search for record information}
\usage{
search_all(type, query)

search_assertions(query)

search_apis(query)

search_atlases(query)

search_collections(query)

search_datasets(query)

search_fields(query)

search_identifiers(...)

search_licences(query)

search_lists(query)

search_profiles(query)

search_providers(query)

search_ranks(query)

search_reasons(query)

search_taxa(...)
}
\arguments{
\item{type}{A string to specify what type of parameters should be searched.}

\item{query}{A string specifying a search term. Searches are not
case-sensitive.}

\item{...}{A set of strings or a tibble to be queried; see
Details.}
}
\value{
An object of class \code{tbl_df} and \code{data.frame} (aka a tibble)
containing all data that match the search query.
}
\description{
The living atlases store a huge amount of information, above and beyond the
occurrence records that are their main output. In \code{galah}, one way that
users can investigate this information is by searching for a specific option
or category for the type of information they are interested in.
Functions prefixed with \code{search_} do this, displaying any matches to a
search term within the valid options for the information specified by the
suffix.

\strong{For more information about taxonomic searches using \code{search_taxa()}, see \code{?taxonomic_searches}}.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
\code{search_all()} is a helper function that can do searches for multiple
types of information, acting as a wrapper around many \code{search_} sub-functions.
See \code{Details} (below) for accepted values.
}
\details{
There are five categories of information, each with their own
specific sub-functions to look-up each type of information.
The available types of information for \code{search_all()} are:\tabular{llll}{
   \strong{Category} \tab \strong{Type} \tab \strong{Description} \tab \strong{Sub-functions} \cr
   configuration \tab \code{atlases} \tab Search for what atlases are available \tab \code{search_atlases()} \cr
    \tab \code{apis} \tab Search for what APIs & functions are available for each atlas \tab \code{search_apis()} \cr
    \tab \code{reasons} \tab Search for what values are acceptable as 'download reasons' for a specified atlas \tab \code{search_reasons()} \cr
   taxonomy \tab \code{taxa} \tab Search for one or more taxonomic names \tab \code{search_taxa()} \cr
    \tab \code{identifiers} \tab Take a universal identifier and return taxonomic information \tab \code{search_identifiers()} \cr
    \tab \code{ranks} \tab Search for valid taxonomic ranks (e.g. Kingdom, Class, Order, etc.) \tab \code{search_ranks()} \cr
   filters \tab \code{fields} \tab Search for fields that are stored in an atlas \tab \code{search_fields()} \cr
    \tab \code{assertions} \tab Search for results of data quality checks run by each atlas \tab \code{search_assertions()} \cr
    \tab \code{licenses} \tab Search for copyright licences applied to media \tab \code{search_licenses()} \cr
   group filters \tab \code{profiles} \tab Search for what data profiles are available \tab \code{search_profiles()} \cr
    \tab \code{lists} \tab Search for what species lists are available \tab \code{search_lists()} \cr
   data providers \tab \code{providers} \tab Search for which institutions have provided data \tab \code{search_providers()} \cr
    \tab \code{collections} \tab Search for the specific collections within those institutions \tab \code{search_collections()} \cr
    \tab \code{datasets} \tab Search for the data groupings within those collections \tab \code{search_datasets()} \cr
}
}
\examples{
\dontrun{
# Search for fields that include the word "date"
search_all(fields, "date")

# Search for fields that include the word "marine"
search_all(fields, "marine")

# Search using a single taxonomic term
# (see `?search_taxa()` for more information)
search_all(taxa, "Reptilia") # equivalent

# Look up a unique taxon identifier
# (see `?search_identifiers()` for more information)
search_all(identifiers, 
           "https://id.biodiversity.org.au/node/apni/2914510")

# Search for species lists that match "endangered"
search_all(lists, "endangered") # equivalent

# Search for a valid taxonomic rank, "subphylum"
search_all(ranks, "subphylum")

# An alternative is to download the data and then `filter` it. This is 
# largely synonymous, and allows greater control over which fields are searched.
request_metadata(type = "fields") |>
 collect() |>
 dplyr::filter(grepl("date", id))
}
}
\seealso{
Use the \code{\link[=show_all]{show_all()}} function and \code{show_all_()} sub-functions to
show available options of information. These functions are used to pass valid
arguments to \code{\link[=filter.data_request]{filter()}},
\code{\link[=select.data_request]{select()}}, and related functions.
Taxonomic queries are somewhat more involved; see \link{taxonomic_searches} for
details.
}
