% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_stepwise.R
\name{stepwise}
\alias{stepwise}
\alias{drop_func}
\alias{stepwise.iModel}
\alias{backward}
\alias{forward}
\title{Stepwise model selection in (graphical) interaction models}
\usage{
drop_func(criterion)

\method{stepwise}{iModel}(
  object,
  criterion = "aic",
  alpha = NULL,
  type = "decomposable",
  search = "all",
  steps = 1000,
  k = 2,
  direction = "backward",
  fixin = NULL,
  fixout = NULL,
  details = 0,
  trace = 2,
  ...
)

backward(
  object,
  criterion = "aic",
  alpha = NULL,
  type = "decomposable",
  search = "all",
  steps = 1000,
  k = 2,
  fixin = NULL,
  details = 1,
  trace = 2,
  ...
)

forward(
  object,
  criterion = "aic",
  alpha = NULL,
  type = "decomposable",
  search = "all",
  steps = 1000,
  k = 2,
  fixout = NULL,
  details = 1,
  trace = 2,
  ...
)
}
\arguments{
\item{criterion}{Either \code{"aic"} or \code{"test"} (for significance test)}

\item{object}{An \code{iModel} model object}

\item{alpha}{Critical value for deeming an edge to be significant/
insignificant. When \code{criterion="aic"}, \code{alpha} defaults to 0;
when \code{criterion="test"}, \code{alpha} defaults to 0.05.}

\item{type}{Type of models to search. Either \code{"decomposable"} or
\code{"unrestricted"}. If \code{type="decomposable"} and the initial
model is decompsable, then the search is among decomposable models only.}

\item{search}{Either \code{'all'} (greedy) or \code{'headlong'} (search edges
randomly; stop when an improvement has been found).}

\item{steps}{Maximum number of steps.}

\item{k}{Penalty term when \code{criterion="aic"}. Only k=2 gives genuine
AIC.}

\item{direction}{Direction for model search. Either \code{"backward"} or
\code{"forward"}.}

\item{fixin}{Matrix (p x 2) of edges. If those edges are in the model,
they are not considered for removal.}

\item{fixout}{Matrix (p x 2) of edges. If those edges are not in the model,
they are not considered for addition.}

\item{details}{Controls the level of printing on the screen.}

\item{trace}{For debugging only}

\item{...}{Further arguments to be passed on to \code{testdelete} (for
\code{testInEdges}) and \code{testadd} (for \code{testOutEdges}).}
}
\description{
Stepwise model selection in (graphical) interaction
models
}
\examples{

data(reinis)
## The saturated model
m1 <- dmod(~.^., data=reinis)
m2 <- stepwise(m1)
m2
}
\seealso{
\code{\link{cmod}}, \code{\link{dmod}}, \code{\link{mmod}},
\code{\link{testInEdges}}, \code{\link{testOutEdges}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{models}
