% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotLines2D}
\alias{plotLines2D}
\title{Plot the lines of a linear mathematical program (Ax = b)}
\usage{
plotLines2D(A, b, nonneg = rep(TRUE, ncol(A)), latex = FALSE, ...)
}
\arguments{
\item{A}{The constraint matrix.}

\item{b}{Right hand side.}

\item{nonneg}{A boolean vector of same length as number of variables. If
entry k is TRUE then variable k must be non-negative and the line is plotted too.}

\item{latex}{If \code{True} make latex math labels for TikZ.}

\item{...}{Further arguments passed on the the \code{ggplot} plotting functions. This must be done as
lists. Currently the following arguments are supported:
\itemize{
\item \code{argsTheme}: A list of arguments for \code{\link[ggplot2:theme]{ggplot2::theme}}.
}}
}
\value{
A \code{ggplot} object.
}
\description{
Plot the lines of a linear mathematical program (Ax = b)
}
\note{
In general you will properly use \code{\link[=plotPolytope]{plotPolytope()}} instead of this function.
}
\seealso{
\code{\link[=plotPolytope]{plotPolytope()}}.
}
\author{
Lars Relund \email{lars@relund.dk}
}
