% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hull.R
\name{hullSegment}
\alias{hullSegment}
\title{Find segments (lines) of a face.}
\usage{
hullSegment(
  vertices,
  hull = geometry::convhulln(vertices),
  tol = mean(mean(abs(vertices))) * sqrt(.Machine$double.eps)
)
}
\arguments{
\item{vertices}{A \verb{m x p} array of vertices of the convex hull, as used by
\code{\link[geometry:convhulln]{geometry::convhulln()}}.}

\item{hull}{Tessellation (or triangulation) generated by \code{\link[geometry:convhulln]{geometry::convhulln()}} If hull is
left empty or not supplied, then it will be generated.}

\item{tol}{Tolerance on the tests for inclusion in the convex hull. You can
think of \code{tol} as the distance a point may possibly lie outside the hull, and
still be perceived as on the surface of the hull. Because of numerical slop
nothing can ever be done exactly here. I might guess a semi-intelligent
value of \code{tol} to be

\verb{tol = 1.e-13*mean(abs(vertices(:)))}

In higher dimensions, the numerical issues of floating point arithmetic
will probably suggest a larger value of \code{tol}.}
}
\value{
A matrix with segments.
}
\description{
Find segments (lines) of a face.
}
\author{
Lars Relund \email{lars@relund.dk}
}
