/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.power;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.af.gMCP.gui.graph.LaTeXTool;
import org.af.gMCP.gui.graph.Node;
import org.af.gMCP.gui.power.PowerReq;
import org.af.gMCP.gui.power.SampleSizeDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PowerReqPanel
extends JPanel
implements ActionListener {
    List<PowerReq> gv = new Vector<PowerReq>();
    JButton addPowerReq = new JButton("Add power requirement");
    JButton rmPowerReq = new JButton("Remove last power requirement");
    SampleSizeDialog sd;
    JPanel panel = new JPanel();

    public PowerReqPanel(SampleSizeDialog sd) {
        this.sd = sd;
        this.gv.add(new PowerReq(sd, "Power requirement " + (this.gv.size() + 1)));
        this.setUpLayout();
    }

    public void setUpLayout() {
        CellConstraints cc = new CellConstraints();
        int row = 2;
        String cols = "5dlu, fill:min:grow, pref, 5dlu, pref, 5dlu";
        String rows = "5dlu, fill:min:grow, 5dlu, pref, 5dlu";
        this.setLayout((LayoutManager)new FormLayout(cols, rows));
        this.add((Component)new JScrollPane(this.getMainPanel()), cc.xyw(2, row, 4));
        this.add((Component)this.addPowerReq, cc.xy(3, row += 2));
        this.add((Component)this.rmPowerReq, cc.xy(5, row));
        this.addPowerReq.addActionListener(this);
        this.rmPowerReq.addActionListener(this);
        this.rmPowerReq.setEnabled(false);
    }

    public JPanel getMainPanel() {
        this.panel.removeAll();
        CellConstraints cc = new CellConstraints();
        int row = 2;
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        String rows = "5dlu, pref, 5dlu";
        for (Node n : this.sd.getNodes()) {
            cols = cols + ", pref, 5dlu";
        }
        for (PowerReq g : this.gv) {
            rows = rows + ", pref, 5dlu";
        }
        this.panel.setLayout((LayoutManager)new FormLayout(cols, rows));
        int col = 2;
        this.panel.add((Component)new JLabel("Name"), cc.xy(col, row));
        this.panel.add((Component)new JLabel("Power requirement"), cc.xy(col += 2, row));
        this.panel.add((Component)new JLabel("Target power / value"), cc.xy(col += 2, row));
        for (Node n : this.sd.nodes) {
            this.panel.add((Component)new JLabel(LaTeXTool.LaTeX2UTF(n.getName()) + "    "), cc.xy(col += 2, row));
        }
        for (PowerReq g : this.gv) {
            g.addComponents(this.panel, cc, row += 2);
        }
        return this.panel;
    }

    public String getPowerTargets() {
        String s = "c(";
        for (PowerReq g : this.gv) {
            s = s + g.targetPower.getText() + ", ";
        }
        return s.substring(0, s.length() - 2) + ")";
    }

    public String getPowerFunctions() {
        String s = "list(";
        for (PowerReq g : this.gv) {
            s = s + g.getPowerfunction() + ", ";
        }
        s = s.substring(0, s.length() - 2) + ")";
        return s;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addPowerReq) {
            PowerReq pr = new PowerReq(this.sd, "Power requirement " + (this.gv.size() + 1));
            this.gv.add(pr);
            pr.setActionListener();
            this.getMainPanel();
            this.revalidate();
            this.repaint();
            this.rmPowerReq.setEnabled(true);
        } else if (e.getSource() == this.rmPowerReq) {
            if (this.gv.size() > 1) {
                this.gv.remove(this.gv.size() - 1);
                this.getMainPanel();
                this.revalidate();
                this.repaint();
            }
            if (this.gv.size() == 1) {
                this.rmPowerReq.setEnabled(false);
            }
        }
    }

    public Element getConfigNode(Document document) {
        Element e = document.createElement("powerreq");
        e.setAttribute("numberPR", "" + this.gv.size());
        e.setAttribute("numberHS", "" + this.gv.get((int)0).includeL.size());
        for (PowerReq pr : this.gv) {
            e.appendChild(pr.getConfigNode(document));
        }
        return e;
    }

    public void loadConfig(Element e) {
        int nPR = Integer.parseInt(e.getAttribute("numberPR"));
        int nHS = Integer.parseInt(e.getAttribute("numberHS"));
        while (this.gv.size() < nPR) {
            this.gv.add(new PowerReq(this.sd, "Power requirement " + (this.gv.size() + 1)));
            this.rmPowerReq.setEnabled(true);
        }
        NodeList nlist = e.getChildNodes();
        for (int i = 0; i < this.gv.size(); ++i) {
            this.gv.get(i).loadConfig((Element)nlist.item(i));
        }
        this.getMainPanel();
        this.revalidate();
        this.repaint();
    }

    public void setActionListener() {
        for (PowerReq pr : this.gv) {
            pr.setActionListener();
        }
    }
}

