% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igraph.R
\name{g6_igraph}
\alias{g6_igraph}
\title{Create a G6 Graph from an igraph Object}
\usage{
g6_igraph(
  graph,
  combos = NULL,
  width = "100\%",
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{graph}{An object of class \code{\link[igraph:aaa-igraph-package]{igraph::igraph}} containing the graph to visualize.}

\item{combos}{A data frame or list of combo groups in the graph. Each combo should have
at least an "id" field. Nodes can be assigned to combos using their "combo" field.
See 'Data Structure' section for more details.
Default: NULL.}

\item{width}{Width of the graph container in pixels or as a valid CSS unit.
Default: NULL (automatic sizing).}

\item{height}{Height of the graph container in pixels or as a valid CSS unit.
Default: NULL (automatic sizing).}

\item{elementId}{A unique ID for the graph HTML element.
Default: NULL (automatically generated).}
}
\value{
An htmlwidget object that can be rendered in R Markdown, Shiny apps, or the R console.
}
\description{
Converts an \code{igraph} graph object into the format required by the \code{g6()} function
and creates an interactive G6 graph visualization. This is a convenience wrapper around
\code{\link[=g6]{g6()}} that allows you to work directly with \code{igraph} objects.
}
\details{
This function extracts the node and edge data from an \code{igraph} object, converts them
into the appropriate format for G6, and passes them to \code{\link[=g6]{g6()}}. Node styling is derived
from vertex attributes, and edge styling from edge attributes.

If the graph is directed, edges will automatically be rendered with arrows.
}
\examples{
if (require(igraph)) {
  g <- igraph::make_ring(5)
  g6_igraph(g)
}

}
\seealso{
\code{\link[=g6]{g6()}} for more information about node, edge, and combo structure.
}
