% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/behaviors.R
\name{collapse_expand}
\alias{collapse_expand}
\title{Configure Collapse Expand Behavior}
\usage{
collapse_expand(
  key = "collapse-expand",
  animation = TRUE,
  enable = TRUE,
  trigger = "dblclick",
  onCollapse = NULL,
  onExpand = NULL,
  align = TRUE,
  ...
)
}
\arguments{
\item{key}{Behavior unique identifier. Useful to modify this behavior from JS side.}

\item{animation}{Enable expand/collapse animation effects (boolean, default: TRUE).}

\item{enable}{Enable expand/collapse functionality (boolean or function, default: TRUE).}

\item{trigger}{Trigger method: "click" or "dblclick" (string, default: "dblclick").}

\item{onCollapse}{Callback function when collapse is completed (function, default: NULL).}

\item{onExpand}{Callback function when expand is completed (function, default: NULL).}

\item{align}{Align with the target element to avoid view offset (boolean, default: TRUE).}

\item{...}{Extra parameters. See \url{https://g6.antv.antgroup.com/en/manual/behavior/collapse-expand}.}
}
\value{
A list with the configuration settings for the collapse-expand behavior.
}
\description{
Creates a configuration object for the collapse-expand behavior in G6.
This allows users to collapse or expand nodes/combos with child elements.
}
\examples{
# Basic configuration
config <- collapse_expand()
}
