% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiraiFutureBackend-class.R
\name{mirai_cluster}
\alias{mirai_cluster}
\title{Mirai-based cluster futures}
\usage{
mirai_cluster(..., envir = parent.frame())
}
\arguments{
\item{envir}{The \link{environment} from where global objects should be
identified.}

\item{\ldots}{Not used.}
}
\value{
Nothing.
}
\description{
\emph{WARNING: This function must never be called.
It may only be used with \code{\link[future:plan]{future::plan()}}}
}
\examples{
# Manually launch mirai workers
mirai::daemons(parallelly::availableCores())

plan(mirai_cluster)

# A function that returns a future
# (note that N is a global variable)
f <- function() future({
  4 * sum((runif(N) ^ 2 + runif(N) ^ 2) < 1) / N
}, seed = TRUE)

# Run a simple sampling approximation of pi in parallel using  M * N points:
N <- 1e6  # samples per worker
M <- 10   # iterations
pi_est <- Reduce(sum, Map(value, replicate(M, f()))) / M
print(pi_est)

## Switch back to sequential processing
plan(sequential)

## Shut down manually launched mirai workers
invisible(mirai::daemons(0))
}
