% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fusionSubcaption.R
\name{fusionSubcaption}
\alias{fusionSubcaption}
\title{Adding FusionCharts subcaption}
\usage{
fusionSubcaption(
  fusionPlot,
  subcaption = "Add a subCaption here",
  subcaptionFont = "Arial",
  subcaptionFontSize = "14",
  subcaptionFontColor = "#999999",
  subcaptionFontBold = FALSE
)
}
\arguments{
\item{fusionPlot}{fusionPlot object got by \code{fusionPlot()}}

\item{subcaption}{Specify the subcaption of the chart}

\item{subcaptionFont}{Set the subcaption font family}

\item{subcaptionFontSize}{Set the subcaption font size (between 0 and 72)}

\item{subcaptionFontColor}{Set the subcaption font color in hex code}

\item{subcaptionFontBold}{Enable subcaption font to bold}
}
\description{
\url{https://www.fusioncharts.com/dev/chart-guide/chart-configurations/caption-and-sub-caption}
}
\examples{
library(fusionchartsR)

mtcars \%>\%
  fusionPlot(
    x = "cyl",
    y = "mpg",
    type = "boxandwhisker2d"
  ) \%>\%
  fusionCaption(caption = "Caption on the left", captionAlignment = "left") \%>\%
  fusionSubcaption(subcaption = "subcaption too") \%>\%
  fusionPalette(palettecolors = c("#5D62B5", "#979AD0")) \%>\%
  fusionTheme(theme = "fusion")

}
