% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wavk_test.R
\name{wavk_test}
\alias{wavk_test}
\title{WAVK Trend Test}
\usage{
wavk_test(
  formula,
  factor.length = c("user.defined", "adaptive.selection"),
  Window = NULL,
  q = 3/4,
  j = c(8:11),
  B = 1000,
  method = c("boot", "asympt"),
  ar.order = NULL,
  ar.method = "HVK",
  ic = "BIC",
  out = FALSE
)
}
\arguments{
\item{formula}{an object of class "\code{\link[stats]{formula}}", specifying the
form of the parametric time trend to be tested. Variable \eqn{t} should be used
to specify the form, where \eqn{t} is specified within the function as a regular
sequence on the interval (0,1]. See \code{Examples}.}

\item{factor.length}{method to define the length of local windows (factors).
Default option\cr \code{"user.defined"} allows setting only one value of the argument
\code{Window}. The option \code{"adaptive.selection"} sets \code{method = "boot"}
and employs heuristic \eqn{m}-out-of-\eqn{n} subsampling algorithm
\insertCite{Bickel_Sakov_2008}{funtimes} to select an optimal window from the set
of possible windows \code{length(x)*q^j} whose values are mapped to the largest
previous integer and greater than 2. Vector \code{x} is the time series tested.}

\item{Window}{length of the local window (factor), default is
\code{round(0.1*length(x))}, where \code{x} is the time series tested.
This argument is ignored if\cr \code{factor.length = "adaptive.selection"}.}

\item{q}{scalar from 0 to 1 to define the set of possible windows when
\code{factor.length =} \code{"adaptive.selection"}. Default is \eqn{3/4}.
This argument is ignored if\cr \code{factor.length =} \code{"user.defined"}.}

\item{j}{numeric vector to define the set of possible windows when
\code{factor.length =} \code{"adaptive.selection"}. Default is \code{c(8:11)}.
This argument is ignored if\cr \code{factor.length = "user.defined"}.}

\item{B}{number of bootstrap simulations to obtain empirical critical values.
Default is 1000.}

\item{method}{method of obtaining critical values: from asymptotical (\code{"asympt"})
or bootstrap (\code{"boot"}) distribution.
If \code{factor.length =} \code{"adaptive.selection"} the option \code{"boot"} is used.}

\item{ar.order}{order of the autoregressive model when \code{ic = "none"}, or
the maximal order for IC-based filtering. Default is
\code{round(10*log10(length(x)))}, where \code{x} is the time series.}

\item{ar.method}{method of estimating autoregression coefficients.
Default \code{"HVK"} delivers robust difference-based estimates by
\insertCite{Hall_VanKeilegom_2003;textual}{funtimes}. Alternatively,
options of \command{ar} function can be used, such as \code{"burg"},
\code{"ols"}, \code{"mle"}, and \code{"yw"}.}

\item{ic}{information criterion used to select the order of autoregressive filter (AIC of BIC),
considering models of orders \eqn{p=} 0,1,...,\code{ar.order}.
If \code{ic = "none"}, the AR(\eqn{p}) model with \eqn{p=} \code{ar.order} is used,
without order selection.}

\item{out}{logical value indicates whether the full output should be shown.
Default is \code{FALSE}.}
}
\value{
A list with class \code{"htest"} containing the following components:
\item{method}{name of the method.}
\item{data.name}{name of the data.}
\item{statistic}{value of the test statistic.}
\item{p.value}{\eqn{p}-value of the test.}
\item{alternative}{alternative hypothesis.}
\item{parameter}{window that was used.}
\item{estimate}{list with the following elements: estimated trend coefficients;
user-defined or IC-selected AR order; estimated AR coefficients; and,
if \code{factor.length =} \code{"adaptive.selection"},
test results for all considered windows.}
}
\description{
Nonparametric test to detect (non-)monotonic parametric trends in time series
\insertCite{@based on @Lyubchich_etal_2013_wavk}{funtimes}.
}
\details{
See more details in \insertCite{Lyubchich_Gel_2016_synchronism;textual}{funtimes}
and \insertCite{Lyubchich_2016_trends;textual}{funtimes}.
}
\examples{
# Fix seed for reproducible simulations:
set.seed(1)

#Simulate autoregressive time series of length n with smooth quadratic trend:
n <- 100
tsTrend <- 1 + 2*(1:n/n) + 4*(1:n/n)^2
tsNoise <- arima.sim(n = n, list(order = c(2, 0, 0), ar = c(-0.7, -0.1)))
U <- tsTrend + tsNoise
plot.ts(U)

#Test H0 of a linear trend, with m-out-of-n selection of the local window:
\dontrun{
    wavk_test(U ~ t, factor.length = "adaptive.selection")}
# Sample output:
##	Trend test by Wang, Akritas, and Van Keilegom (bootstrap p-values)
##
##data:  U
##WAVK test statistic = 5.3964, adaptively selected window = 4, p-value < 2.2e-16
##alternative hypothesis: trend is not of the form U ~ t.

#Test H0 of a quadratic trend, with m-out-of-n selection of the local window
#and output of all results:
\dontrun{
    wavk_test(U ~ poly(t, 2), factor.length = "adaptive.selection", out = TRUE)}
# Sample output:
##	Trend test by Wang, Akritas, and Van Keilegom (bootstrap p-values)
##
##data:  U
##WAVK test statistic = 0.40083, adaptively selected window = 4, p-value = 0.576
##alternative hypothesis: trend is not of the form U ~ poly(t, 2).
##sample estimates:
##$trend_coefficients
##(Intercept) poly(t, 2)1 poly(t, 2)2
##   3.408530   17.681422    2.597213
##
##$AR_order
##[1] 1
##
##$AR_coefficients
##         phi_1
##[1] -0.7406163
##
##$all_considered_windows
## Window WAVK-statistic p-value
##      4     0.40083181   0.576
##      5     0.06098625   0.760
##      7    -0.57115451   0.738
##     10    -1.02982929   0.360

# Test H0 of no trend (constant trend) using asymptotic distribution of statistic.
wavk_test(U ~ 1, method = "asympt")
# Sample output:
##	Trend test by Wang, Akritas, and Van Keilegom (asymptotic p-values)
##
##data:  U
##WAVK test statistic = 25.999, user-defined window = 10, p-value < 2.2e-16
##alternative hypothesis: trend is not of the form U ~ 1.

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[stats]{ar}}, \code{\link{HVK}}, \code{\link{WAVK}},
\code{\link{sync_test}}, \code{vignette("trendtests", package = "funtimes")}
}
\author{
Yulia R. Gel, Vyacheslav Lyubchich, Ethan Schaeffer
}
\keyword{htest}
\keyword{trend}
\keyword{ts}
