% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getKsPCAData.R
\name{getKsPCAData}
\alias{getKsPCAData}
\title{Get K Functions and Compute Principal Components}
\usage{
getKsPCAData(
  data,
  outcome = colnames(data)[1],
  unit = colnames(data)[5],
  replicate = NULL,
  rCheckVals = NULL,
  nPCs = 3,
  agents_df = as.data.frame(expand.grid(unique(data[, 4]), unique(data[, 4]))),
  xRange = NULL,
  yRange = NULL,
  edgeCorrection = "isotropic",
  nbasis = 21,
  silent = FALSE,
  displayTVE = FALSE
)
}
\arguments{
\item{data}{Data.frame with column titles for at least outcome, x, y, agents,
and unit. For consistency (and avoiding errors), use that order.
Additionally, replicate can be added.}

\item{outcome}{(Optional) String of the column name in data indicating the
outcome or response. Default is the 1st column.}

\item{unit}{(Optional) String of the column name in data indicating a unit or
base thing. Note this unit may have replicates. Default is the 4th
column.}

\item{replicate}{(Optional) String of the column name in data indicating the
replicate id. Default is NULL.}

\item{rCheckVals}{(Optional) Numeric vector indicating the radius to check.
Note, if not specified, this could take a lot of memory, particularly
with many units and replicates.}

\item{nPCs}{(Optional) Numeric indicating the number of principal components.}

\item{agents_df}{(Optional) Two-column data.frame. The first for agent 1
and the second for agent 2. Both should be in data agents column. This
determines which K functions to compute. Default is to compute all, but
may be misspecified if the data is in a different order.}

\item{xRange, yRange}{(Optional) Two value numeric vector indicating the min
and max x/y values. Note this is re-used for all replicates. The default
just takes the min and max x from each replicate. This allows different
sized images, but the edges are defined by some agent location.}

\item{edgeCorrection}{(Optional) String indicating type of edgeCorrection(s)
to apply when computing the K functions. Options include: "border",
"bord.modif", "isotropic", "Ripley", "translate", "translation", "periodic",
"none", "best" or "all" selects all options.}

\item{nbasis}{(Optional) Numeric indicating number of basis functions to fit
K functions in order to compute PCA. Current implementation uses a
b-spline basis.}

\item{silent}{(Optional) Boolean indicating if progress should be printed.}

\item{displayTVE}{(Optional) Boolean to  indicate if total variance explained
(TVE) should be displayed. Default is FALSE.}
}
\value{
Data.frame with the outcome, unit and principle components of
computed K functions.
}
\description{
This function computes K functions from point process data then converts it
into PCs. Note, if there are replicates, i.e. multiple observations per
unit, the K functions will be a weighted average based on the number of
the first agents.
}
\examples{
dataPCA_pheno <- getKsPCAData(
  data = TNBC_pheno, unit = "Person",
  agents_df = data.frame(rep("B", 2), c("Tumor", "Fake")),
  nPCs = 3,
  rCheckVals = seq(0, 50, 1),
  displayTVE = TRUE
)
}
