% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcv.R
\name{fcv}
\alias{fcv}
\title{Functional Cross-Validation mapping}
\usage{
fcv(.splits, .f, ncores = NULL, pb = FALSE, ...)
}
\arguments{
\item{.splits}{A list of resample splits (e.g., from `rsample::vfold_cv()`).}

\item{.f}{A function to apply to each split. Typically expects a single `split` object.}

\item{ncores}{Integer. Number of cores to use for parallel processing. Default is `NULL` (sequential).}

\item{pb}{Logical. Whether to display a progress bar. Default is `FALSE`.}

\item{...}{Additional arguments passed to `.f`.}
}
\value{
A list of results returned by applying `.f` to each element of `.splits`.
}
\description{
Applies a user-defined function `.f` to each element of `.splits`, typically from
cross-validation objects such as `rsample::vfold_cv()`.
}
\examples{
if (requireNamespace("rsample", quietly = TRUE)) {
  set.seed(123)
  cv_splits <- rsample::vfold_cv(mtcars, v = 5)

  # Apply summary over training sets
  fcv(cv_splits$splits, function(split) {
    summary(rsample::analysis(split))
  })

  # With progress and parallel execution
  \donttest{
    fcv(cv_splits$splits, function(split) {
      summary(rsample::analysis(split))
    }, ncores = 2, pb = TRUE)
  }
}

}
